#!/usr/local/bin/perl
package descrypt;
use integer;

# descrypt.pl v 1.1
# Perl5 p DES crypt Cu
# Copyright (c) 1997-2002 Mikeneko Lab. All Rights Reserved.
#
# }VɈˑɁApure perl ɂ DES Ís܂B
# perl  crypt ƁAAԂlłB
#
# 쐬: ~PlR
# URL   : http://www.mikeneko.ne.jp/~lab/
# A: lab@mikeneko.ne.jp
#
# g
# require "descrypt.pl";
# print &descrypt::encrypt($pass, $salt);
#
# $pass: pX[hƂȂL[B8 oCg𒴂͐؂܂B
# $salt: Í saltB[./0-9A-Za-z] ̒ 2 Iт܂B

# s
sub init{

@Data = (
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
);

@Initial_Permutation_left = (
	57, 49, 41, 33, 25, 17,  9,  1,
	59, 51, 43, 35, 27, 19, 11,  3,
	61, 53, 45, 37, 29, 21, 13,  5,
	63, 55, 47, 39, 31, 23, 15,  7
);
@Initial_Permutation_right = (
	56, 48, 40, 32, 24, 16,  8,  0,
	58, 50, 42, 34, 26, 18, 10,  2,
	60, 52, 44, 36, 28, 20, 12,  4,
	62, 54, 46, 38, 30, 22, 14,  6
);

@Initial_Permutation_inverse = (
	39, 7, 47, 15, 55, 23, 63, 31,
	38, 6, 46, 14, 54, 22, 62, 30,
	37, 5, 45, 13, 53, 21, 61, 29,
	36, 4, 44, 12, 52, 20, 60, 28,
	35, 3, 43, 11, 51, 19, 59, 27,
	34, 2, 42, 10, 50, 18, 58, 26,
	33, 1, 41,  9, 49, 17, 57, 25,
	32, 0, 40,  8, 48, 16, 56, 24,
);

@Permuted_Choice_1_left = (
	56, 48, 40, 32, 24, 16,  8,
	0,  57, 49, 41, 33, 25, 17,
	9,  1,  58, 50, 42, 34, 26,
	18, 10,  2, 59, 51, 43, 35
);

@Permuted_Choice_1_right = (
	62, 54, 46, 38, 30, 22, 14,
	6,  61, 53, 45, 37, 29, 21,
	13,  5, 60, 52, 44, 36, 28,
	20, 12,  4, 27, 19, 11,  3
);

@Permuted_Choice_2 = (
	13, 16, 10, 23,  0,  4,
	 2, 27, 14,  5, 20,  9,
	22, 18, 11,  3, 25,  7,
	15,  6, 26, 19, 12,  1,
	40, 51, 30, 36, 46, 54,
	29, 39, 50, 44, 32, 47,
	43, 48, 38, 55, 33, 52,
	45, 41, 49, 35, 28, 31
);

@E_Bit_Selection = (
	31,  0,  1,  2,  3,  4,
	 3,  4,  5,  6,  7,  8,
	 7,  8,  9, 10, 11, 12,
	11, 12, 13, 14, 15, 16,
	15, 16, 17, 18, 19, 20,
	19, 20, 21, 22, 23, 24,
	23, 24, 25, 26, 27, 28,
	27, 28, 29, 30, 31,  0
);

@S_BOX = (
[
	14,  0,  4, 15, 13,  7,  1,  4,   2, 14, 15,  2, 11, 13,  8,  1,
	 3, 10, 10,  6,  6, 12, 12, 11,   5,  9,  9,  5,  0,  3,  7,  8,
	 4, 15,  1, 12, 14,  8,  8,  2,  13,  4,  6,  9,  2,  1, 11,  7,
	15,  5, 12, 11,  9,  3,  7, 14,   3, 10, 10,  0,  5,  6,  0, 13
],[
	15,  3,  1, 13,  8,  4, 14,  7,   6, 15, 11,  2,  3,  8,  4, 14,
	 9, 12,  7,  0,  2,  1, 13, 10,  12,  6,  0,  9,  5, 11, 10,  5,
	 0, 13, 14,  8,  7, 10, 11,  1,  10,  3,  4, 15, 13,  4,  1,  2,
	 5, 11,  8,  6, 12,  7,  6, 12,   9,  0,  3,  5,  2, 14, 15,  9
],[
	10, 13,  0,  7,  9,  0, 14,  9,   6,  3,  3,  4, 15,  6,  5, 10,
	 1,  2, 13,  8, 12,  5,  7, 14,  11, 12,  4, 11,  2, 15,  8,  1,
	13,  1,  6, 10,  4, 13,  9,  0,   8,  6, 15,  9,  3,  8,  0,  7,
	11,  4,  1, 15,  2, 14, 12,  3,   5, 11, 10,  5, 14,  2,  7, 12
],[
	 7, 13, 13,  8, 14, 11,  3,  5,   0,  6,  6, 15,  9,  0, 10,  3,
	 1,  4,  2,  7,  8,  2,  5, 12,  11,  1, 12, 10,  4, 14, 15,  9,
	10,  3,  6, 15,  9,  0,  0,  6,  12, 10, 11,  1,  7, 13, 13,  8,
	15,  9,  1,  4,  3,  5, 14, 11,   5, 12,  2,  7,  8,  2,  4, 14
],[
	 2, 14, 12, 11,  4,  2,  1, 12,   7,  4, 10,  7, 11, 13,  6,  1,
	 8,  5,  5,  0,  3, 15, 15, 10,  13,  3,  0,  9, 14,  8,  9,  6,
	 4, 11,  2,  8,  1, 12, 11,  7,  10,  1, 13, 14,  7,  2,  8, 13,
	15,  6,  9, 15, 12,  0,  5,  9,   6, 10,  3,  4,  0,  5, 14,  3
],[
	12, 10,  1, 15, 10,  4, 15,  2,   9,  7,  2, 12,  6,  9,  8,  5,
	 0,  6, 13,  1,  3, 13,  4, 14,  14,  0,  7, 11,  5,  3, 11,  8,
	 9,  4, 14,  3, 15,  2,  5, 12,   2,  9,  8,  5, 12, 15,  3, 10,
	 7, 11,  0, 14,  4,  1, 10,  7,   1,  6, 13,  0, 11,  8,  6, 13
],[
	 4, 13, 11,  0,  2, 11, 14,  7,  15,  4,  0,  9,  8,  1, 13, 10,
	 3, 14, 12,  3,  9,  5,  7, 12,   5,  2, 10, 15,  6,  8,  1,  6,
	 1,  6,  4, 11, 11, 13, 13,  8,  12,  1,  3,  4,  7, 10, 14,  7,
	10,  9, 15,  5,  6,  0,  8, 15,   0, 14,  5,  2,  9,  3,  2, 12
],[
	13,  1,  2, 15,  8, 13,  4,  8,   6, 10, 15,  3, 11,  7,  1,  4,
	10, 12,  9,  5,  3,  6, 14, 11,   5,  0,  0, 14, 12,  9,  7,  2,
	 7,  2, 11,  1,  4, 14,  1,  7,   9,  4, 12, 10, 14,  8,  2, 13,
	 0, 15,  6, 12, 10,  9, 13,  0,  15,  3,  3,  5,  5,  6,  8, 11
]
);

@Permutation_Function = (
	15,  6, 19, 20, 28, 11, 27, 16,
	 0, 14, 22, 25,  4, 17, 30,  9,
	 1,  7, 23, 13, 31, 26,  2,  8,
	18, 12, 29,  5, 21, 10,  3, 24
);

@Crypt_String = ( ".", "/", 0..9, "A" .. "Z", "a" .. "z");

}


# -------------------------------------------------------------------------
# Crypt ̃CE[eB
sub encrypt{
	# 󂯎
	my ($key, $salt) = @_;
	my ($data, $schedule);

	# ݒ
	&init;
	$data     = \@Data;                # : k 64 bit
	$salt     = &salt_hashing($salt);  # salt: sd̒us
	$schedule = &key_scheduling($key); # XPW[O: DES ɉe

	#  data ɑ΂āADES  25 񂩂
	for (my $i = 0; $i < 25; $i++){
		$data = &des($data, $schedule);
	}

	# 64bit  data AŏIÍl crypt ɕϊ
	return join ("", $salt,
		map {
			$Crypt_String[
				32 * $data->[$_ * 6]     + 16 * $data->[$_ * 6 + 1] +
				 8 * $data->[$_ * 6 + 2] +  4 * $data->[$_ * 6 + 3] +
				 2 * $data->[$_ * 6 + 4] +      $data->[$_ * 6 + 5]
			]
		} (0..10)
	);

}

# -------------------------------------------------------------------------
# DES ̃ASY
sub des{
	local( *data, *schedule) = @_;

	# u(Initial Permutation) sAO 32bit ƁA 32 bit ɕ
	my $left  = [ @data[ @Initial_Permutation_left  ] ];
	my $right = [ @data[ @Initial_Permutation_right ] ];

	# 16 ǐXPW[ɂāAleft  right 
	foreach $schedule ( @schedule ){ # 16 ĩ[v

		# dŁA32bit ̌s 48 bit ֊gu
		my $cipher_f = [
			@$right[ @E_Bit_Selection ]
		];

		# XPW[Op SBOX 璊oꂽ 32bit sA
		# Permutation_Function ŒuB
		# ̂PŁAcryptpp SH̖ 70 ̎ԂĂI
		$cipher_f = [
			@{ &sbox($cipher_f, $schedule) }[ @Permutation_Function]
		];

		# =EAE Xor f(E,) 
		( $left, $right ) = 
		( [@$right], [
			($left->[ 0] ^ $cipher_f->[ 0]), ($left->[ 1] ^ $cipher_f->[ 1]),
			($left->[ 2] ^ $cipher_f->[ 2]), ($left->[ 3] ^ $cipher_f->[ 3]),
			($left->[ 4] ^ $cipher_f->[ 4]), ($left->[ 5] ^ $cipher_f->[ 5]),
			($left->[ 6] ^ $cipher_f->[ 6]), ($left->[ 7] ^ $cipher_f->[ 7]),
			($left->[ 8] ^ $cipher_f->[ 8]), ($left->[ 9] ^ $cipher_f->[ 9]),
			($left->[10] ^ $cipher_f->[10]), ($left->[11] ^ $cipher_f->[11]),
			($left->[12] ^ $cipher_f->[12]), ($left->[13] ^ $cipher_f->[13]),
			($left->[14] ^ $cipher_f->[14]), ($left->[15] ^ $cipher_f->[15]),
			($left->[16] ^ $cipher_f->[16]), ($left->[17] ^ $cipher_f->[17]),
			($left->[18] ^ $cipher_f->[18]), ($left->[19] ^ $cipher_f->[19]),
			($left->[20] ^ $cipher_f->[20]), ($left->[21] ^ $cipher_f->[21]),
			($left->[22] ^ $cipher_f->[22]), ($left->[23] ^ $cipher_f->[23]),
			($left->[24] ^ $cipher_f->[24]), ($left->[25] ^ $cipher_f->[25]),
			($left->[26] ^ $cipher_f->[26]), ($left->[27] ^ $cipher_f->[27]),
			($left->[28] ^ $cipher_f->[28]), ($left->[29] ^ $cipher_f->[29]),
			($left->[30] ^ $cipher_f->[30]), ($left->[31] ^ $cipher_f->[31]) 
		] );
	}

	# R16  L16 Aus IP-1 ʂ̔z̃t@XA
	# ŏIÍƂĕԂ
	return [ (@$right, @$left)[ @Initial_Permutation_inverse] ];
}

# ---------------------------------------------------------------------
# S-BOX ̒o
# 48bit sƁA48bit Ƃ̌XPW[O Xor vZA
# temp[48] ̊erbgvZAS-BOX ̒ 4bit  8 oA
# 炪ׂĂQiϊꂽ 32 bit zԂB

sub sbox{
	my $data = shift;
	local *schedule = shift;

	return [
		map {
			( (8 & $_) >> 3 , (4 & $_) >> 2, (2 & $_) >> 1, 1 & $_);
		}
		(
$S_BOX[0][
 32 * ($data->[0] ^ $schedule[0] )   + 16 * ($data->[1] ^ $schedule[1] ) +
  8 * ($data->[2] ^ $schedule[2] )   +  4 * ($data->[3] ^ $schedule[3] ) +
  2 * ($data->[4] ^ $schedule[4] )   +      ($data->[5] ^ $schedule[5] )
],
$S_BOX[1][
 32 * ($data->[6] ^ $schedule[6] )   + 16 * ($data->[7] ^ $schedule[7] ) +
  8 * ($data->[8] ^ $schedule[8] )   +  4 * ($data->[9] ^ $schedule[9] ) +
  2 * ($data->[10] ^ $schedule[10] ) +      ($data->[11] ^ $schedule[11] )
],
$S_BOX[2][
 32 * ($data->[12] ^ $schedule[12] ) + 16 * ($data->[13] ^ $schedule[13] ) +
  8 * ($data->[14] ^ $schedule[14] ) +  4 * ($data->[15] ^ $schedule[15] ) +
  2 * ($data->[16] ^ $schedule[16] ) +      ($data->[17] ^ $schedule[17] )
],
$S_BOX[3][
 32 * ($data->[18] ^ $schedule[18] ) + 16 * ($data->[19] ^ $schedule[19] ) +
  8 * ($data->[20] ^ $schedule[20] ) +  4 * ($data->[21] ^ $schedule[21] ) +
  2 * ($data->[22] ^ $schedule[22] ) +      ($data->[23] ^ $schedule[23] )
],
$S_BOX[4][
 32 * ($data->[24] ^ $schedule[24] ) + 16 * ($data->[25] ^ $schedule[25] ) +
  8 * ($data->[26] ^ $schedule[26] ) +  4 * ($data->[27] ^ $schedule[27] ) +
  2 * ($data->[28] ^ $schedule[28] ) +      ($data->[29] ^ $schedule[29] )
],
$S_BOX[5][
 32 * ($data->[30] ^ $schedule[30] ) + 16 * ($data->[31] ^ $schedule[31] ) +
  8 * ($data->[32] ^ $schedule[32] ) +  4 * ($data->[33] ^ $schedule[33] ) +
  2 * ($data->[34] ^ $schedule[34] ) +      ($data->[35] ^ $schedule[35] )
],
$S_BOX[6][
 32 * ($data->[36] ^ $schedule[36] ) + 16 * ($data->[37] ^ $schedule[37] ) +
  8 * ($data->[38] ^ $schedule[38] ) +  4 * ($data->[39] ^ $schedule[39] ) +
  2 * ($data->[40] ^ $schedule[40] ) +      ($data->[41] ^ $schedule[41] )
],
$S_BOX[7][
 32 * ($data->[42] ^ $schedule[42] ) + 16 * ($data->[43] ^ $schedule[43] ) +
  8 * ($data->[44] ^ $schedule[44] ) +  4 * ($data->[45] ^ $schedule[45] ) +
  2 * ($data->[46] ^ $schedule[46] ) +      ($data->[47] ^ $schedule[47] )
]

	)
	];

}


# ---------------------------------------------------------------------
# salt ɂusd̂

sub salt_hashing{
	my ($salt) = @_;

	#  2 oCgɖȂꍇ́A󔒂ŃpeBOiŗŏ
	$salt .= " " x (2 - length $salt) if (length $salt < 2);

	# 1 oCgƂ salt  salt R[hɕϊAuƂs܂B
	my $srand_flag;
	my $e_offset = 0;
	for (my $i = 0; $i < 2; $i++){
		my $saltcode = unpack ("C", substr ($salt, $i, 1) );

		# Ks܂
		if ( $saltcode > 0x2D && $saltcode < 0x3A ){
			$saltcode -= 0x2E; # 46
		}elsif ($saltcode > 0x40 && $saltcode < 0x5B ){
			$saltcode -= 0x35; # 53
		}elsif ($saltcode > 0x60 && $saltcode < 0x7B ){
			$saltcode -= 0x3B; # 59
		}else{
			if (! $srand_flag){ srand (); $srand_flag++; }
			$saltcode = (int rand(0x8000) & 0x7E) >> 1;
			substr ($salt, $i, 1) = $Crypt_String[ $saltcode ]; # K
		}

		# 6bit  salt ɏ]As E_Bit_Selection ̒us܂
		for ( split //, unpack("b6", pack("C", $saltcode )) ){
			if ($_){
				@E_Bit_Selection[ $e_offset, 24 + $e_offset ] = 
				@E_Bit_Selection[ 24 + $e_offset, $e_offset ];
			}
			$e_offset++;
		}
	}
	
	return $salt;
}
# ----------------------------------------------------------------
# XPW[O

sub key_scheduling{
	#  j 󂯎B
	my ($key) = @_;

	# j 8 i8oCgjɐK
	if (length $key < 8){ $key .= "\x00" x (8 - length $key); }
	if (length $key > 8){ substr ($key, 8) = ""; }

	# 8byte ̏̕A64 vf̔z֗Ƃ
	# e 擪 1bit c 7bit gi[B8bit ڂgȂ
	my @key = split //, unpack("B64", $key);
	shift @key; push (@key, 0);

	# ob|PŏkuA擪 28bit  㔼 28 bit ɕ
	my $left  = [ @key[ @Permuted_Choice_1_left ] ];
	my $right = [ @key[ @Permuted_Choice_1_right] ];

	# PUǐXPW[zւ̃t@XԂB
	return
	[
		map {
			push (@$left,  splice (@$left,  0, $_) ); #  left Vtg
			push (@$right, splice (@$right, 0, $_) ); # right Vtg
			# O 56bit ֍̂Aob|QŏkuAɓ
			[ (@$left, @$right)[ @Permuted_Choice_2 ] ];
		} (1, 1, 2, 2,  2, 2, 2, 2,  1, 2, 2, 2,  2, 2, 2, 1)
	]
}

1;

