package jconv;
require 5.000;
use integer;

# jconv.pm ver 5.9
# ʸѴ饤֥
# Copyright (c) 1997-2003 Mikeneko Lab. All Rights Reserved.


#-------------------------------------------------------------------#
# Ѵݥꥷ
#-------------------------------------------------------------------#

sub init{
	($Policy_h2z, $Policy_vender, $Policy_binary) = @_;
	&flushcache();
}

#-------------------------------------------------------------------#
# ѴȥǤ
#-------------------------------------------------------------------#

sub convert{
	my ($str, $ocode, $icode) = @_;
	my @str;

	####	Х٤Ȥˡڤ
	my $div = 65536;
	while (length $str){
		pos $str = $div;
		$str =~ /\n/g;
		if (pos $str){
			push (@str, substr ($str, 0, pos $str) );
			substr ($str, 0, pos $str) = "";
		}else{
			push (@str, $str);
			last;
		}
	}

	$icode ||= ( &check_encode($str[0]) )[0];
	$ocode ||= $icode;

	$_[0] = join ("",
		map { &{$convert_gateway{$icode}{$ocode}}($_) } @str
	);
}

#-------------------------------------------------------------------#
# 󥳡ɤåޤ
#-------------------------------------------------------------------#
sub check_encode{
	my $str = shift;
	my (%code, @code);

	# Υץ󥹤Ĥ뤫
	{
		my $pos = index ($str, "\x1B");
		last unless $pos > -1;

		my $seq = substr ($str, $pos + 1, 1);
		return "jis" if $seq eq "\x24" || $seq eq "\x28";
	}

	# SJIS 뤤 EUC
	$code{"sjis"} += length($1) while ( $str =~ /((?:$L_sjis)+)/go );
	$code{"euc"}  += length($1) while ( $str =~ /((?:$L_euc)+)/go  );

	# ƱȤä硢⤦ܤĴ٤
	if ( $code{"sjis"} == $code{"euc"} ){
		my $tmp;

		$tmp = $str;
		$tmp =~ s/($L_sjis)+//go;
		$tmp =~ s/[$L_asc]//go;
		$code{"sjis"} -= length($tmp);

		$tmp = $str;
		$tmp =~ s/($L_euc)+//go;
		$tmp =~ s/[$L_asc]//go;
		$code{"euc"} -= length($tmp);
	}

	# ֥Ȥι⤤ɤ֤
	sort {$code{$b} <=> $code{$a}} ("sjis", "euc");
}

#-------------------------------------------------------------------#
# åեå夷ޤ
#-------------------------------------------------------------------#
sub flushcache{
	undef %cache_s2e;
	undef %cache_s2j;
	undef %cache_e2s;
	undef %cache_e2j;
}


#-------------------------------------------------------------------#
# Shift_JIS Ѵ롼ƥ
#-------------------------------------------------------------------#

sub conv_sjis2euc{
	my $str = shift;
	my ($c1, $c2) = unpack('CC', $str);

	if ($c2 < 0x9F) {
		$c1 += $c1 - ($c1 >= 0xE0 ? 0xE1 : 0x61);
		$c2 += 0x60 + ($c2 < 0x7F);
	} else {
		$c1 += $c1 - ($c1 >= 0xE0 ? 0xE0 : 0x60);
		$c2 += 2;
	}

	$cache_s2e{$str} = pack('CC', $c1, $c2);
};

sub conv_sjis2jis {
	my $str = shift;
	my ($c1, $c2) = unpack('CC', $str);

	if ($c2 < 0x9F) {
		$c1 += $c1 - ($c1 >= 0xE0 ? 0xE1 : 0x61);
		$c2 += 0x60 + ($c2 < 0x7F);
	} else {
		$c1 += $c1 - ($c1 >= 0xE0 ? 0xE0 : 0x60);
		$c2 += 2;
	}
	$cache_s2j{$str} = pack('CC', $c1 - 0x80, $c2 - 0x80);
};

sub conv_euc2sjis{
	my $str = shift;
	my ($c1, $c2) = unpack('CC', $str);

	if ($c1 % 2){	# 
		$c1 = ( $c1 + ($c1 < 0xDF ? 0x61 : 0xE1) ) >> 1;
		$c2 -= 0x60 + ($c2 < 0xE0);
	}else{				# 
		$c1 = ( $c1 + ($c1 < 0xDF ? 0x60 : 0xE0) ) >> 1;
		$c2 -= 2;
	}

	$cache_e2s{$str} = pack('CC', $c1, $c2);
};

sub conv_euc2jis {
	$_[0] ^ "\x80" x length $_[0];
};

sub conv_jis2euc{
	$_[0] | "\x80" x length $_[0];
};

sub conv_jis2sjis{
	my $str = shift;
	&{ $convert_gateway{euc}{sjis}}( &conv_jis2euc($str) );
};

sub conv_jis2jis{
	$Seq_jis{"2b"} . $_[0] . $Seq_jis{"1b"};
};


BEGIN {

	# Ascii, SJIS, EUC, JIS, UTF-8 Υϰ
	# ߤΥСϡUTF-8 ̤ѤǤ
	$L_asc   = '\x21-\x7E';
	$L_asc_c = '\x09\x0A\x0D\x20';
	$L_sjis  = '[\x81-\x84\x88-\x9F\xE0-\xEA][\x40-\x7E\x80-\xFC]';
	$L_euc   = '[\xA1-\xA8\xB0-\xF4][\xA1-\xFE]';
	$L_jis   = '[\x21-\x28\x30-\x74][\x21-\x7E]';
	$L_utf8_2b = '[\xC0-\xD][\x80-\xBF]';
	$L_utf8_3b = '[\xE0-\xEF][\x80-\xBF][\x80-\xBF]';

	# JIS ץ
	$Seq_jis_2b = join('|',
	 '\x1B\x24\x40',			# JIS C 6226-1978(JIS)    [ESC] $ @
	 '\x1B\x24\x42',			# JIS X 0208-1983(JIS83)  [ESC] $ B
	);
	$Seq_jis_1b = join('|',
	 '\x1B\x28\x42',			# ASCII                     [ESC] ( B
	 '\x1B\x28\x4A',			# JIS X0201-1976 ޻   [ESC] ( J
	);
	$Seq_jis_han =
	 '\x1B\x28\x49';			# JIS X0201-1976 Ҳ̾     [ESC] ( I

	#  JIS ץ
	$Seq_jis{"2b"} = "\x1B\x24\x42";
	$Seq_jis{"1b"} = "\x1B\x28\x42";
	$Seq_jis{"han"} = "\x1B\x28\x49";

	# SJIS ѥѥޥå
	$L_sjis_pattern = join("|",
		"((?:$L_sjis)+)", 
		"([$L_asc$L_asc_c]+)",
		"([\xA1-\xDF])",
		"([\x81-\xFC][\x40-\x7E\x80-\xFC])",
		"([\x00-\xFF])"
	);
	# EUC ѥѥޥå
	$L_euc_pattern = join("|",
		"((?:$L_euc)+)", 
		"([$L_asc$L_asc_c]+)",
		"\x8E([\xA1-\xDF])",
		"([\xA1-\xFE][\xA1-\xFE])",
		"([\x00-\xFF])",
	);
	# JIS ѥѥޥå
	$L_jis_pattern = join("|",
		"($Seq_jis_2b)((?:$L_jis)*)", 
		"($Seq_jis_1b)([$L_asc$L_asc_c]*)",
		"($Seq_jis_han)([\x21-\x5F$L_asc_c]*)",
		"([\xA1-\xDF]+)",
		"[\x21-\x7E][\x21-\x7E]",
		"[\x00-\xFF]",
	);

	# 
	$Geta{"sjis"} = "\x81\xAC";
	$Geta{"euc"}  = "\xA2\xAE";
	$Geta{"jis"}  = "\x22\x2E";

	########		Ⱦѥ -> ѥʥȥ
	my @tmp = (0xA1 .. 0xAF, 0xB0 .. 0xBF, 0xC0 .. 0xCF , 0xD0 .. 0xDF);
	foreach  (
     '!#','!V','!W','!"','!&','%r','%!','%#','%%',"%'",'%)','%c','%e','%g','%C','!<','%"','%$','%&','%(','%*','%+','%-','%/','%1','%3','%5','%7','%9','%;','%=','%?','%A','%D','%F','%H','%J','%K','%L','%M','%N','%O','%R','%U','%X','%[','%^','%_','%`','%a','%b','%d','%f','%h','%i','%j','%k','%l','%m','%o','%s','!+','!,'
	){
		$h2z{ chr (shift @tmp) } = $_ | "\x80\x80";
	}

	$conv_h2z = sub{
		my $str = shift;
		$str =~ s/([\xA1-\xDF])/ $h2z{$1} /eg;
		$str;
	};

	########		SJIS 
	$convert_gateway{sjis}{sjis} = sub {
		my ($str) = @_;
		my $fix;

		while ( $str =~ /$L_sjis_pattern/go ){
			if ($1 ne ""){
				$fix .= $1;
			}elsif ($2 ne ""){
				$fix .= $2;
			}elsif ($3 ne ""){
				if ($Policy_h2z){
					$fix .= &$conv_h2z($3);
				}else{
					$fix .= $3;
				}
			}elsif ($4 ne ""){
				if ($Policy_vender){
					$fix .= $Geta{sjis};
				}else{
					$fix .= $4;
				}
			}else{
				if ($Policy_binary){
					$fix .= $Geta{sjis};
				}else{
					$fix .= $5;
				}
			}
		}

		$fix;
	};

	$convert_gateway{sjis}{euc} = sub {
		my ($str) = @_;
		my $fix;

		while( $str =~ /$L_sjis_pattern/go ){
			if ($1 ne ""){
				my $tmp = $1;
				my $i;
				for ($i = 0; $i < length $tmp; $i += 2) {
					$fix .= $cache_s2e{     substr ($tmp, $i, 2) } ||
					        &conv_sjis2euc( substr ($tmp, $i, 2) );
				}
			}elsif ($2 ne ""){
				$fix .= $2;
			}elsif ($3 ne ""){
				if ($Policy_h2z){
					$fix .= &$conv_h2z($3);
				}else{
					$fix .= "\x8E" . $3;
				}
			}elsif ($4 ne ""){
				if ($Policy_vender){
					$fix .= $Geta{euc};
				}else{
					$fix .= &conv_sjis2euc( $4 );
				}
			}else{
				if ($Policy_binary){
					$fix .= $Geta{euc};
				}else{
					$fix .= &conv_sjis2euc( $5 );
				}
			}
		}
		$fix;
	};

	$convert_gateway{sjis}{jis} = sub {
		my ($str) = @_;

		my $fix = $Seq_jis{"2b"};
		while( $str =~ /$L_sjis_pattern/go ){
			if ($1 ne ""){
				my $tmp = $1;
				my $i;
				for ($i = 0; $i < length $tmp; $i += 2) {
					$fix .=  $cache_s2j{     substr ($tmp, $i, 2) } ||
								   &conv_sjis2jis( substr ($tmp, $i, 2) );
				}
			}elsif ($2 ne ""){
				$fix .= join ($2, $Seq_jis{"1b"}, $Seq_jis{"2b"} ),
			}elsif ($h2z && $3 ne ""){
				$fix .= &conv_euc2jis(&$conv_h2z($3));
			}else{
				$fix .= $Geta{jis};
			}
		}
		$fix .= $Seq_jis{"1b"};
		$fix;
	};
	

	########		EUC 

	$convert_gateway{euc}{euc} = sub {
		my ($str) = @_;
		my $fix;
		while( $str =~ /$L_euc_pattern/go ){
			if ($1 ne ""){
				$fix .= $1;
			}elsif ($2 ne ""){
				$fix .= $2;
			}elsif ($3 ne ""){
				if ($Policy_h2z){
					$fix .= &$conv_h2z($3);
				}else{
					$fix .= "\x8E" . $3;
				}
			}elsif ($4 ne ""){
				if ($Policy_vender){
					$fix .= $Geta{euc};
				}else{
					$fix .= $4;
				}
			}else{
				if ($Policy_binary){
					$fix .= $Geta{euc};
				}else{
					$fix .= $5;
				}
			}
		}

		$fix;
	};

	$convert_gateway{euc}{sjis} = sub {
		my ($str) = @_;
		my $fix;
		while( $str =~ /$L_euc_pattern/go ){
			if ($1 ne ""){
				my $tmp = $1;
				my $i;
				for ($i = 0; $i < length $tmp; $i += 2) {
					$fix .=  $cache_e2s{     substr ($tmp, $i, 2) } ||
					         &conv_euc2sjis( substr ($tmp, $i, 2) );
				}
			}elsif ($2 ne ""){
				$fix .= $2;
			}elsif ($3 ne ""){
				if ($Policy_h2z){
					$fix .= &conv_euc2sjis(&$conv_h2z($3));
				}else{
					$fix .= $3;
				}
			}elsif ($4 ne ""){
				if ($Policy_vender){
					$fix .= $Geta{sjis};
				}else{
					$fix .= &conv_euc2sjis( $4 );
				}
			}else{
				if ($Policy_binary){
					$fix .= $Geta{sjis};
				}else{
					$fix .= &conv_euc2sjis( $5 );
				}
			}
		}
		$fix;
	};

	$convert_gateway{euc}{jis} = sub {
		my ($str) = @_;
		my $fix = $Seq_jis{"2b"};
		while( $str =~ /$L_euc_pattern/go ){
			if ($1 ne ""){
				$fix .= &conv_euc2jis($1);
			}elsif ($2 ne ""){
				$fix .= join ($2, $Seq_jis{"1b"}, $Seq_jis{"2b"} );
			}elsif ($h2z && $3 ne ""){
				$fix .= &conv_euc2jis(&$conv_h2z($3))
			}else{
				$fix .= $Geta{jis};
			}
		}
		$fix .= $Seq_jis{"1b"};
		$fix;
	};

	########		JIS 
	$convert_gateway{jis}{sjis} = sub {
		my ($str) = @_;

		my $fix;
		$str = $Seq_jis{"1b"} . $str if $str !~ /^(\x1B)/;

		while( $str =~ /$L_jis_pattern/go ){
			if ($1 ne ""){
				$fix .= &conv_jis2sjis($2);
			}elsif ($3 ne ""){
				$fix .= $4;
			}elsif ($h2z && $5 ne ""){
				my $tmp = $6;
				while ( $tmp =~ /([\x21-\x5F])|([$L_asc_c])/go ){
					if ($1 ne ""){
						$fix .= &conv_euc2sjis( &$conv_h2z( &conv_jis2euc($1) ) );
					}else{
						$fix .= $2;
					}
				}
			}elsif ($h2z && $7 ne ""){
				$fix .= &conv_euc2sjis( &$conv_h2z($7) );
			}else{
				$fix .= $Geta{sjis};
			}
		}
		$fix;
	};

	$convert_gateway{jis}{euc} = sub {
		my ($str, $ocode) = @_;
		my $fix;
		$str = $Seq_jis{"1b"} . $str if $str !~ /^\x1B/;

		while( $str =~ /$L_jis_pattern/go ){
			if ($1 ne ""){
				$fix .= &conv_jis2euc($2);
			}elsif ($3 ne ""){
				$fix .= $4;
			}elsif ($h2z && $5 ne ""){
				my $tmp = $6;
				while ( $tmp =~ /([\x21-\x5F])|([$L_asc_c])/go ){
					if ($1 ne ""){
						$fix .=  &$conv_h2z( &conv_jis2euc($1) );
					}else{
						$fix .= $2;
					}
				}
			}elsif ($h2z && $7 ne ""){
				$fix .= &$conv_h2z($7);
			}else{
				$fix .= $Geta{euc};
			}
		}
		$fix;
	};

	$convert_gateway{jis}{jis} = sub {
		my ($str) = @_;
		my $fix;
		$str = $Seq_jis{"1b"} . $str if $str !~ /^\x1B/;
		while( $str =~ /$L_jis_pattern/go ){
			if ($1 ne ""){
				$fix .= &conv_jis2jis($2);
			}elsif ($3 ne ""){
				$fix .= $4;
			}elsif ($h2z && $5 ne ""){
				my $tmp = $6;
				while ( $tmp =~ /([\x21-\x5F])|([$L_asc_c])/go ){
					if ($1 ne ""){
						$fix .= &conv_euc2jis( &$conv_h2z( &conv_jis2euc($1) ) );
					}else{
						$fix .= $2;
					}
				}
			}elsif ($h2z && $7 ne ""){
				$fix .= &conv_euc2jis( &$conv_h2z($7) );
			}else{
				$fix .= $Geta{jis};
			}
		}
		$fix;
	};
}


1;
