package mikecookie;
require 5.000;

# mikecookie.pm
# CommuniCa 5.3 ѥå⥸塼
# Copyright (c) 1997-2003 Mikeneko Lab. All Rights Reserved.

# use mikecookie;

BEGIN {

	#	
	$SCRIPT{"name"}		= 'Mikeneko Cookie';
	$SCRIPT{"version"}= '5.3.0';
	$SCRIPT{"url"}		= 'http://www.mikeneko.ne.jp/~lab/cgi/communica/';
	$SCRIPT{"email"}	= 'lab@mikeneko.ne.jp';

}

sub new{
	my $class = shift;
	my $self = {};
	bless $self, $class;
	$self->init;
	$self;
}

sub DESTROY{ }

# 
sub init{
	my $self = shift;
	
	####	٤ƤͤФ
	foreach ( split (/;\s*/, $ENV{'HTTP_COOKIE'}) ){
		next unless /^([^=]*)=(.*)$/;
		$self->{cookie}->{$1} = $2;
		$self->{cookie}->{MAGIC} = $2 if length $2;
	}

	1;
}

# åФget, set, expire

sub define{
	my $self = shift;
	my $name = shift;

	length $self->{cookie}->{$name};
}

sub get{
	my $self = shift;
	my $name = shift;

	decode( $self->{cookie}->{$name} );
}

sub expire{
	my $self = shift;
	my ($name, $domain, $path) = @_;

	$self->httpcookie ( $name, "expires", -1000, $domain, $path );
}

sub set{
	my $self = shift;

	$self->httpcookie ( @_ );
}


sub httpcookie{
	my $self = shift;

	my ($name, $value, $expires, $domain, $path) = @_;

	return unless $name;

	#	åѴ֤
	my ($sec, $min, $hour, $mday, $mon, $year, $wday)
		= gmtime(time + $expires);

	my $expires_gmt = sprintf (
		"%3s, %2.2d-%3s-%4.4d %2.2d:%2.2d:%2.2d GMT",
		("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat") [$wday],
		$mday,
		("Jan", "Feb", "Mar", "Apr", "May", "Jun",
		 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec") [$mon],
		1900 + $year,
		$hour, $min, $sec
	);

	join("",
		"Set-Cookie: "	,
		$name, "=", $value,	"; ",
		($expires_gmt	? "expires=$expires_gmt; "	: ""),
		($domain	? "domain=$domain; "	: ""),
		($path	? "path=$path; "	: ""),
		"\r\n"
	);

}

# ǥ
sub decode{
	map {

		my ($key, $value) = split (/=/, $_, 2);

		$key   =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("c", hex($1))/ge;
		$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("c", hex($1))/eg;

		$key =~ tr/ //d;

		($key, $value);

	}( split /&/, shift );
}

1;
