package mikeio;
require 5.000;

# mikeio.pm
# CommuniCa 5.3  I/O ⥸塼
# Copyright (c) 1997-2003 Mikeneko Lab. All Rights Reserved.

# եϥɥ򥪥֥Ȳơե򥪡ץ󤷤ޤ
# ֥Ȥǡեϱ˥ץ󤵤졢
# ֥Ȥ˴ǡեϱ˥ޤ

# åƤޤ
# 餫λǡåޤޥץबλ褦ʤȤäƤ⡢
# ưŪ˥åޤ

# use mikeio;

########################################################
# եΥץ󡢥

# ե򥪡ץ󤹤롣
# $fh = new mikeio ( ե̾, ⡼ ) or die;

# ե򥯥롣
# undef $fh;

########################################################
# ե뤫

# getlines()
# <FILEHANDLE> ƱͤΤȤԤޤ
# @lines = $fh->getlines;

# getline()
# scalar <FILEHANDLE> ƱͤΤȤԤޤ
# $lines = $fh->getline;

# head(\@array, $lines, $skips)
# ߤΥݥ󥿹Ԥ顢( $skips Ԥ򥹥åפ) $lines Ԥɤߤޤ
# $fh->head(\@lines, 10 );

# tail(\@array, $lines, $skips)
# ե顢( $skips Ԥ򥹥åפ) $lines Ԥɤߤޤ
# $fh->tail(\@lines, 10 );


########################################################
# եؤν

# print FILEHANDLE @lines ƱͤΤȤԤ
# $fh->print(@lines);

########################################################
# եϥɥ

# stat (FILEHANDLE) ƱͤΤȤԤ
# եϥɥľ뤳ȤϤǤޤ󤬡stat Τ褦ʴؿϡ
# ե̾Ƥ⤦ޤưΤǡstat ($fh->filename) ǡ
# ԤɤưˤʤǤ礦



BEGIN {

	#	
	$SCRIPT{"name"}		= 'Mikeneko I/O';
	$SCRIPT{"version"}= '5.3.2';
	$SCRIPT{"url"}		= 'http://www.mikeneko.ne.jp/~lab/cgi/communica/';
	$SCRIPT{"email"}	= 'lab@mikeneko.ne.jp';

}

sub new{
	my $class = shift;
	my $self = {};
	bless $self, $class;

	if (@_) {
		$self->filename(shift);
	}

	$self;
}

sub DESTROY{
	my $self = shift;
	$self->close;
	$self->lockoff;
#	print "auto closed\n";
}

# $fh->open( FILENAME, FILEMODE )
# եۤ˥ץ󤷤ޤ

sub open {
	my $self = shift;

	# ץ
	my $mode = shift;
	$mode = "<" if ! defined $mode;

	$self->filename(shift) if @_;
	return if ! defined $self->filename;

	# ˡʥեϥɥ
	$self->filehandle( $self->filename );

	open ($self->filehandle, $mode . $self->filename) or return;
	binmode ($self->filehandle);

	$mode;
}

# $fh->close( )
# եۤ˥ޤ
sub close{
	my $self = shift;
	close ($self->filehandle);
}


# $fh->filename ( FILENAME )
# ե̾Ф륢᥽åɡ

sub filename{
	my $self = shift;
	@_	? $self->{filename} = shift
			: $self->{filename};
}

# $fh->filehandle ( FILENAME )
# եϥɥФ륢᥽åɡ

sub filehandle {
	my $self = shift;
	my $handle = shift;
	if (! defined $handle){
		local (*FH) = $self->{handle};
		return *FH;
	}

	$handle = "MIKEIO" . $handle;
	$handle =~ s/\W//g;

	$self->{handle} = $handle;
}



####	Ϸ

# getline()   --  1 Ԥɤߤ֤ޤ
# getlines()  --  Ԥɤߤ֤ޤ
# getlines( \@array )  --  \@array Ԥɤߤߤޤ
#                          @array = getlines() ®

sub getline{
	my $self = shift;
	local (*FH) = $self->filehandle;
	scalar (<FH>);
}

sub getlines{
	my $self = shift;
	local (*FH) = $self->filehandle;

	$_[0] ? @{$_[0]} = <FH>
				: <FH>;
}

# tail ( \@array [, $lines [, $skip ] ]  )
# ե顢Ԥɤߤߤޤ
# ɬɤߤߤˤʤޤ
sub tail{
	my $self = shift;

	my ($array, $lines, $skip) = @_;
	$self->_tail ($array, $lines, $skip);
}

sub _tail{
	my $self = shift;

	my ($array, $lines, $skip) = @_;
	my ($filesize, $blksize, $blocks, $last_buffer, $line_number);
	local (*FH) = $self->filehandle;

	# ֥åν
	($filesize, $blksize) = (stat FH)[7, 11];

	# ѿν
	$blksize = 16384 if $blksize < 1;
	$lines   =    10 if $lines   < 1;
	$skip    =     0 if $skip    < 1;
	$blocks  = int ($filesize / $blksize);

	# å;פѰ
	my @buffer; $#buffer = 64; @buffer = ();
	$#$array = 64 + $lines; @$array = ();

	####	֥å򥵡ޤ

	while ($blocks + 1) {

		####	֥åѿ˳Ǽ
		seek (FH, $blocks * $blksize, 0);

		@buffer = ();
		my ($len, $buffer);

		while ($buffer = <FH>){
			push (@buffer, $buffer);
			$len += length $buffer;
			last if $len >= $blksize; #֥åʬɤ齪λ
		}

		$last_buffer = shift @buffer;
		push (@buffer, scalar <FH>) if (! eof && $len == $blksize);

		$line_number += @buffer;  # ХåեˤޤäԿץ饹
		unshift (@$array, @buffer) if ($skip < $line_number);
		last if $line_number >= $lines + $skip; # ɬ׹Կɤæ

		$blocks --;
	}

	####	while롼פθ
	if ($blocks < 1){ # ǽ֥åä
		$line_number ++;
		unshift (@$array, $last_buffer) if $skip < $line_number + 1;
	}

	####	ɤߤʬ򥫥å
	splice (@$array, 0, $line_number - $lines - $skip)
		if $line_number > $lines + $skip;

	####	åʬ򥫥å
	my $real_skip;
	if ($skip > 0){
		if ($line_number < $skip){ # åפιԤϡˤϤʤä
			@$array = ();
			$real_skip = $line_number;
		}elsif ($line_number > $lines + $skip){
			splice (@$array, $lines);
			$real_skip = $skip;
		}else{
			splice (@$array, $line_number - $skip);
			$real_skip = $skip;
		}
	}

	return ($line_number, $lines, $real_skip);
}


# $fh->head ( \@array [, $lines [, $skips ] ]  )
# եƬ顢Ԥɤߤߤޤ
# ɬɤߤߤˤʤޤ

sub head{
	my $self = shift;

	my ($array, $lines, $skips) = @_;

	return if ! defined $array;

	# ѿν
	$lines   =    10 if $lines   < 1;
	$skips    =    0 if $skips   < 1;
	local (*FH) = $self->filehandle;

	if ($skips){        # å
		for (1..$skips) { scalar <FH> }
	}
	for (1..$lines) { push (@$array, scalar <FH>) }  # ɤ߽Ф

	1;
}

####	Ϸ

# $fh->print ( LIST )
# ʸϤޤ
sub print {
	my $self = shift;
	local (*FH) = $self->filehandle;
	print FH @_;
}


############	եå
# եå¸뤿ˤϡåե뤬ɬפȤʤޤ
# åǥ쥯ȥ꤬񤭤Բǽä硢顼֤ޤ

# $fh->init (LOCKDIR [, METHOD]) or die "åǤ֤ˤޤ";
# $fh->on () or die "åǤޤǤ";
# $fh->off () or die "åξõ˼Ԥޤ";

sub lockinit{
	my $self = shift;
	my ($lockdir, $method) = @_;

	return if ! defined $lockdir;
	$! = "permittion denyed $lockdir", return if ! -w $lockdir;

	# å̵ä硢ڥ졼󥷥ƥȽ̤ơ
	# ŬåưȽ̤ޤ

	if (! $method){

		if      ( $^O =~ /Win/i ){
			$self->lockmethod("mkdir");
		}elsif  ( $^O =~ /^MacOS$/i ){
			$self->lockmethod("mkdir");
		}else{
			$self->lockmethod("symlink");
		}

	}

	my $lockname = $self->{filename};
	$lockname =~ s/\W+/_/g;
	$self->{lockname} = $lockdir . "/" . $lockname;
	1;
}

# åΥ᥽å

sub lockmethod{
	my $self = shift;
	@_	? $self->{lockmethod} = shift
			: $self->{lockmethod};
}

# symlink 뤤ϡmkdir ǻޤ

sub lockon{
	my $self = shift;

	# åեνϽƤ뤫
	return if ! defined $self->{lockname};
	return if ! defined $self->{lockmethod};

	if ($self->{lockmethod} eq "mkdir"){
		return $self->lock_mkdir;
	}else{
		return $self->lock_symlink;
	}

}

sub lock_symlink{
	my $self = shift;

	my $loop = 1;
	while (! symlink("$$", $self->{lockname})){
		$loop ++;

		if ($loop > 4){
			$self->lockoff or $self->errormsg("Υ顼ˤꡢåե($self->{lockname})õǤޤǤ֥饦 Back äƤ");
			$self->errormsg("ޥեåǤ߹äƤ褦Ǥ֥饦 Back äƤ");
		}
		sleep (3);
	}

	$loop; # 롼ܤ֤Ǿͤϣ
}



sub lock_mkdir{
	my $self = shift;

	my $loop = 1;
	while (! mkdir($self->{lockname}, 755)){
		$loop ++;

		if ($loop > 4){
			$self->lockoff or $self->errormsg("Υ顼ˤꡢåǥ쥯ȥ($self->{lockname})õǤޤǤ֥饦 Back äƤ");
			$self->errormsg("ޥեåǤ߹äƤ褦Ǥ֥饦 Back äƤ");
		}
		sleep (3);
	}

	$loop; # 롼ܤ֤Ǿͤϣ
}

sub lockoff{
	my $self = shift;

	return unless $self->{lockname};

	if ($self->{lockmethod} eq "mkdir"){
			return rmdir $self->{lockname};
	}else{
			return unlink $self->{lockname};
	}

}

sub errormsg{
	my $self = shift;
	$@ = shift;
	undef;
}

1;
