package mikepaint;

# 󥸥mikeneko_paint
# CommuniCa 5.3  ⥸塼
# Copyright (C) 1997-2003 Mikeneko Lab.
# All Rights Reserved.

# ᥽åɤμ
# sub new()
# sub colorfile($filename)
# sub cachlimit($num)
# sub load_db()
# sub save_db()
# sub add($name1, $name2)
# sub html($msg)
# sub msg($msg)

####	Ķ


BEGIN {

	#	
	$SCRIPT{"name"}		= 'Mikeneko Paint';
	$SCRIPT{"version"}= '2.3.4';
	$SCRIPT{"url"}		= 'http://www.mikeneko.ne.jp/~lab/cgi/communica/';
	$SCRIPT{"email"}	= 'lab@mikeneko.ne.jp';

}

sub new{
	my $class = shift;
	my $self = {};
	bless $self, $class;
	$self;
}


####	ǡեΥ᥽å

sub colorfile{
	my $self = shift;
	@_	? $self->{color_file} = shift
			: $self->{color_file};
}

####	å¤Υ᥽å

sub cachlimit{
	my $self = shift;
	@_	? $self->{cach_limit} = int (shift) || 20
			: $self->{cach_limit};
}

####	ꥹȤΥ᥽å
sub list{
	my $self = shift;
	@_	? push ( @{ $self->{list} }, shift )
			: @{ $self->{list} };
}


####	ȥꥹ
sub sorted_list{
	my $self = shift;
	return @{ $self->{sorted_list} } if defined $self->{sorted_list};

	@{ $self->{sorted_list} } =
		sort { length($b) <=> length($a) } ( $self->list ); # ʸĹǥ
}



####	ǡե򡢥ϥå˳Ǽ

sub load_db{
	my $self = shift;

	# ǡ١ʤ顢⤦ס
	return 1 if defined $self->list;

	# 顼ե뤬̤ǤСäѤ
	return 1 unless defined $self->colorfile;

	#	եȤ򣱹ԤĲϤޤ
	open (COLORIN, $self->colorfile)
	 or &error("ѥե" . $self->colorfile . "ޤ");

	while (<COLORIN>){

		next if /^#/;
		chomp;
		my ($name1, $name2, $type, $ssn) = split /\t/;

		#	
		next unless ($name1 && $name2);
		$type = 0 if ($type > 3 || $type < 0);
		$ssn  = 0 if ($ssn  > 1 || $ssn  < 0);

		#	ϥå
		$self->{db}->{$name1} = [$name2, $type, $ssn];
		$self->list($name1);

	}
	close (COLORIN);

	1;
}



####	ǡɲ

sub add{
	my $self = shift;

	# ǡ١
	$self->load_db;

	# 顼ե뤬̤ǤС⤦빽
	return 1 unless defined $self->colorfile;

	my ($pattern, $replace) = @_;

	#	ѿ
	return if
	( 
		! length ($replace)			||
		length($pattern) < 2 		||
		length($pattern) > 50		||
		$pattern =~ /^[0-9]+$/	||
		$pattern =~ /^[\xA1-\xA8].$/	||
		$pattern =~ /[^\x20-\x7E\xA1-\xFE]/ ||
		$replace =~ /[\n\r\t]/	||
		$pattern eq $replace
	);



	#	ǡ١ˡǤˤ뤫
	if ( defined $self->{db}->{$pattern} ){

		# äʤСǡФƤ롣
		my ($db_replace, $type, $ssn) = @{ $self->{db}->{$pattern} };
		$type = 0 unless $type;
		$ssn  = 0 unless $ssn;

		#	ʤС񤭴٤
		if ($db_replace ne $replace && $type != 2){

			#	ǡ١򹹿ޤ
			$self->{db}->{$pattern} = [$replace, $type, $ssn];

			#	ǡ١¸ޤ
			$self->save_db;
		}

	}else{
		#	ǡ١̵С¸

		#	硼ȥߥ顼͡Ƚ
		my $ssn = $self->check_ssname($pattern);

		#	ǡ١򹹿ޤ
		$self->{db}->{$pattern} = [$replace, '0', $ssn];
		$self->list($pattern);
		delete $self->{sorted_list};

		#	ǡեɵޤ
		open (COLOROUT, ">>" . $self->colorfile)
		 or &error("ѥե(" . $self->colorfile . ")¸Ǥޤ");
		print COLOROUT (
			$pattern, "\t", $replace, "\t", '0', "\t", $ssn, "\n"
		);
		close (COLOROUT); 
	}

	1;
}

####	硼ȥߥ顼͡फɤȽǤ롣

sub check_ssname{
	my $self = shift;

	my $pattern = shift;

	return 1 if
		(
				length($pattern) < 4
			or

				length($pattern) == 6 || length($pattern) == 4
			and
				$pattern =~ /^(.).(?:\1.)+$/	&&
				ord $1 >= 0xA1 &&
				ord $1 <= 0xA8
			or

				$pattern =~ /^[\x00-\x7F]+$/
		);
	0;
}


####	ߤΥǡ١¸
# ȤƤݤʤȤäƤ褦̤˹٤㤤ΤǡǤ褤
sub save_db{
	my $self = shift;

	my (@db_perm, @db_regu, @db_cach);

	foreach $line ( $self->list ){
		if    ($self->{db}->{$line}->[1] == 2)	{ push (@db_perm, $line); }
		elsif ($self->{db}->{$line}->[1] == 1)	{ push (@db_regu, $line); }
		else																		{ push (@db_cach, $line); }
	}

	#	å
	shift @db_cach while ($self->cachlimit < @db_cach);

	#	ǡ١ǡեȿǤޤ

	open (COLOROUT, ">" . $self->colorfile )
	 or &error("ѥե" . $self->colorfile . "¸Ǥޤ");
	print COLOROUT <<"--- --- PAINT DB --- ---";
# <HTML><BODY><PRE>
# 󥸥Mikeneko Paint(required perl5)
# Copyright (C) 1997-2003 Mikeneko Lab.
#
# Υե$SCRIPT{"name"} $SCRIPT{"version"}ѤΡǡ١Ǥ
# 󥳡ɤ EUC-JP Ǥɬפޤ
# ===================  Υեθ =======================
# ֥          <FONT color="#FFA500">֥</FONT>         1          0
# [ñ]   [ñ]    [°]     []
# ===============================================================
# ƥեɴ֤ϡTAB ʸ 1 ĤǶڤޤ
#
# [°]
# °0: Ūʥå
# °1: ػ
# °2: Ѷػ
# []
# 0: ̵
# 1: 硼ȥߥ顼͡

--- --- PAINT DB --- ---

	print COLOROUT (
		"\n# [°2: Ѷػ : ǽץǡϤ]\n",
		map (join ("\t", $_, @{ $self->{db}->{$_} } ) . "\n" , @db_perm),
		"\n# [°1: ػ : ϢϤ]\n",
		map (join ("\t", $_, @{ $self->{db}->{$_} } ) . "\n" , @db_regu),
		"\n# [°0: Ūʥå :  ", scalar @db_cach,
		"  ( ", $self->cachlimit, " ͤޤ)¸Ǥޤ]\n",
		map (join ("\t", $_, @{ $self->{db}->{$_} } ) . "\n" , @db_cach),
	);
	close (COLOROUT);

	1;
}

####	HTML󥿥ʬ륲ȥǤ

sub html{
	my $self = shift;

	join ("",
		map
			{ (/^</ && />$/) ? $_ : $self->msg($_) }
			( split /(<[^>]*?>)/, $_[0] )
	);
}



####	åޤ
sub msg{
	my $self = shift;
	my $msg  = shift;
	my ($count, %trans_name);
	$count = 100; # ɬ

	$self->load_db;

	foreach $name1 ( grep { $msg =~ m/\Q$_\E/ } $self->sorted_list ){

		my ($name2, $type, $ssn) = @{ $self->{db}->{$name1} };
		$trans_name{++$count} = $name2;

		if ($ssn){
			&ssname($name1, \$msg, $count);
		}else{
			$msg =~ s/\Q$name1\E/\x00$count/g;
		}

	}

	$msg =~ s/\x00(\d\d\d)/$trans_name{$1}/g;
	$msg;
}

####	硼ȥߥ顼͡Ԥޤ
##	ʥˤĤ¿äɽǤ®٤ؤαƶϤޤ

sub ssname{

	my ($name, $msg, $count) = @_;
	my (@msg, $sscode);
	@msg = split (/\Q$name\E/, $$msg, -1);
	$sscode = unpack("C", $name);

	# while 롼 
	my ($buf1, $buf2, $flag_fix, $fixed_msg);
	$flag_fix  = 0;
	$fixed_msg = "a" x length $$msg; $fixed_msg = "";
	$buf2      = shift @msg;

	SSNAME:
	while (@msg){

		# Хåե򥷥ե
		($buf1, $buf2) = ($buf2, shift @msg);
		$fixed_msg .= $buf1;
		next unless ! length $buf2 && @msg;

		# ϢϤ٤̵
		# @msg  undef ޤޤƤ顢Ϣ줬 split 줿̡
		# ɡ$buf1 ݻƤˤΥ롼ɬ
		$fixed_msg .= $name;
		while (1){
			$buf2 = shift @msg;
			$fixed_msg .= $name;
			last SSNAME if ! @msg;
			redo SSNAME if length $buf2;
		}

	}continue{

		# ɤν
		#            ֤   <䤹> ߤʤ
		# Хåե  $buf1 = ""   $buf2 = "ߤʤ"
		#     $code1         $code2
		my ($code1a, $code1b, $code2a, $code2b, $code2c) = ();

		##  2bytes
		if (length($buf1) > 1){
			($code1a, $code1b) = unpack("CC", substr($buf1, -2) );
		}

		##  3byte
		$code2a  = unpack("C", substr($buf2, 0, 1)) if (length($buf2) > 0);
		$code2b  = unpack("C", substr($buf2, 1, 1)) if (length($buf2) > 1);
		$code2c  = unpack("C", substr($buf2, 2, 1)) if (length($buf2) > 2);

		# flag = 1 ΤȤ롣
		my $flag;

		####	äȤ¿
		if (
			$buf2 =~ /^/    ||  # 󤬸³С
			length($buf1) == 0      # ʸƬǤС
		){
			$flag = 1;

		####	ɾΤ³С
		}elsif (
			$buf2 =~ /^(||||||||||||)/	||
			$buf2 =~ /^([\xA1-\xA5][\xA1-\xFE])(||)/	||
			$buf2 =~ /^([\xA1-\xA5][\xA1-\xFE])(||)/	||
			$buf2 =~ /^(||)([\xA1-\xA4][\xA1-\xFE]){0,2}(|)/		||
			$buf2 =~ /^(||)([\xA1-\xA5][\xA1-\xFE]){0,2}(|)/		||
			$buf2 =~ /^(||)/		||
			$buf2 =~ /^/	||
			$buf2 =~ /^(||||||||)/
		){
			$flag = 1;

		####	ʸὪüǤС
		}elsif (
			$buf2 =~ /^/          ||
			$buf2 =~ /^ä[^\xA4]/ ||
			$buf2 =~ /^[^\xA4]/ ||
			$buf2 =~ /^[^\xA4]/ ||
			$buf2 =~ /^ˤ[^\xA4]/ ||
			$buf2 =~ /^ˤ[^\xA4]/ ||
			$buf2 =~ /^Ȥ[^\xA4]/ ||
			$buf2 =~ /^ʤ[^\xA4]/ ||
			$buf2 =~ /^[^\xA4]/   ||
			$buf2 =~ /^[^\xA4]/   ||
			$buf2 =~ /^[^\xA4]/   ||
			$buf2 =~ /^[^\xA4]/   ||
			$buf2 =~ /^[^\xA4]/   ||
			$buf2 =~ /^[^\xA4]/
		){
			$flag = 1;

		####	Ҥ餬ʰʳΤȤʸǤ
		}elsif (
			$sscode != 0xA4 and
			length($buf2) == 0 ||
			$buf2 =~ /^/     ||
			$buf2 =~ /^/
		){
			$flag = 1;

		####	ΤȤȤ˴Ҥ餬ʰʳǤС
		}elsif (
			$sscode > 0xA8 and
			$code1a < 0xA9 && $code1a != 0xA4 and
			$code2a < 0xA9 && $code2a != 0xA4
		){
			$flag = 1;

		####	쥯ȤθǤС
		}elsif (
			$buf1 =~ /$/ ||
			$buf1 =~ /$/ ||
			$buf1 =~ /\]$/ ||
			$buf1 =~ /<$/  ||
			$buf1 =~ />$/
		){
			$flag = 1;

		####	Ǥʤꤷޤ
		}elsif (

			####	ûʸä
			length($name) < 3

			or

			####	ȾѱѿΤȤɤ餫Ⱦѱѿä
			$sscode < 0x7F	and
			($code1b < 0x7F && $code1b > 0x21) ||
			($code2a < 0x7F && $code2a > 0x21)

			or

			####	ñɤ餫Ʊʸä
			$sscode == $code1a	||
			$sscode == $code2a

			or

			####	Ĺɤ餫ˤСʸ³
			$buf1 =~ /$/ ||
			$buf1 =~ /$/ ||
			$buf2 =~ /^/ ||
			$buf2 =~ /^/

			or

			####	Ҥ餬ʤΤȤɤ餫ʤ
			$sscode == 0xA4	and
			($code1a > 0xA8 && $code1b > 0xA0 ) || $code2a > 0xA8

		){
			$flag = 0;
		}else{
			$flag = 1;
		}

		if ($flag){
			$fixed_msg .= "\x00$count";
			$flag_fix ++;
		}else{
			$fixed_msg .= $name;
		}

	} # end of SSNAME: while loop

	# ⤷Ƥ顢ѹ
	$$msg = join("", $fixed_msg, $buf2 ) if $flag_fix;
	1;
}

###########   顼

sub error {
	print <<EOM;
Content-type: text/html

<HTML>
<HEAD>
	<TITLE>ץ 顼</TITLE>
</HEAD>
<BODY>
<H1>Mikeneko Paint Υ顼Ǥ</H1>
@_
</BODY>
</HTML>
EOM
	exit(1);
}

1;

