package mikequery;

# mikequery.cgi ver 2.0
# CommuniCa 5.3  Query 饤֥
# Copyright (c) 1997-2003 Mikeneko Lab. All Rights Reserved.

# 㡧GET ޤ POST ɤ߽ФFORM ϥå
#{
#	my ($result, $query);
#
# require "mikequery.cgi";
#	($result, $query) = &mikequery::read();
#	&SystemAlert($result) if $result;
#	$result           = &mikequery::urlencoded($query, \%FORM);
#	&SystemAlert($result) if $result;
#}

########	꡼ʬ

# ̸ߴ
package main;
sub query
{
	my ($result, %form);

	($result, $QUERY) = &mikequery::read();
	die if $result;

	$result           = &mikequery::urlencoded($QUERY, \%form);
	die if $result;

	return %form;
}

package mikequery;

####	GET ޤ POST ǥǡɤߤ
sub read{
	if( $ENV{'REQUEST_METHOD'} eq 'POST'){
		&read_post();
	}else{
		&read_get();
	}
}

####	ɸϤǡɤߤ
sub read_post{

	my $data;
	my $blocksize = 65536;

	my $buf;
	my $remain = $ENV{'CONTENT_LENGTH'};
	while ($remain > 0) {
		$remain -= read(STDIN, $buf, $blocksize);
		$data .= $buf;

		return (1) if (
			$::CONFIG{'query_limit'} > 0 &&
			length($data) > $::CONFIG{'query_limit'}
		);
	}

	return (0, $data);
}

####	GET ǡɤߤ
sub read_get{
	return (1) if (
		$::CONFIG{query_limit} > 0 &&
		length($ENV{QUERY_STRING}) > $::CONFIG{query_limit}
	);
	return (0, $ENV{QUERY_STRING});
}

####	MODE ѿ
sub read_mode{
	if ( $ENV{QUERY_STRING} =~ /^(\w+)[^\w]/ ){
		return $1;
	}
}

####	application/x-www-form-urlencoded ꡼
sub urlencoded {
	my ($data, $rh_form) = @_;

	$data =~ tr/+/ /;
	my @data = split (/&/, $data);

	# üѿ mode
	my $mode;
	if ( index($data[0], "=") < 0 ){
		my $value = shift @data;
		$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("c", hex($1))/eg;
		$value =~ s/\r\n?/\n/g;
		&jconv::convert($value, "euc", $::CONFIG{jcode_input});
		${$rh_form}{mode} = $value ;
	}

	foreach ( @data ){
		($key, $value) = split (/=/, $_, 2);
		$key   =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("H2", $1 )/eg;
		$key   =~ s/\r\n?/\n/g;
		$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("H2", $1 )/eg;
		$value =~ s/\r\n?/\n/g;
		&jconv::convert($value, "euc", $::CONFIG{jcode_input});
		${$rh_form}{$key} = $value ;
	}

	0;
}
####	multipart/form-data ꡼
sub multipart{
	my ($data, $rh_form, $rh_file) = @_;
	my @formdata;
	my ($delimiter, $error);

	{
		my ($pos, $ofset);
		# ǥߥ롣
		$pos = index($data, "\r\n");
		$delimiter = substr ($data, 0, $pos);
		$ofset = $pos + 2;

		# ǥߥȤʬ
		while (1){
			last unless ($pos = index($data, $delimiter, $ofset)) > -1;
			push (@formdata, substr ($data, $ofset, $pos - $ofset) );
			$ofset = $pos + length($delimiter) + 2;
		}

	}

	# ƥեǡˤĤơإåȥܥǥʬ
	foreach $formdata (@formdata){

		my ($ofset, $pos, %head, $body);

		# إåȥܥǥʬΥ
		for ($i = 1; $i < 10; $i++){
			return ("multipart parse error 1") unless ($pos = index ($formdata, "\r\n", $ofset)) > -1;
			my $line = substr ($formdata, $ofset, $pos - $ofset);
			$ofset = $pos + 2;

			last if length($line) < 1; # إåϽλ

			return ("multipart parse error 2") unless $line =~ /^([^:]+):\s*([\x00-\xff]*)\s*$/;
			$head{lc($1)} = $2;
		}
		$body = substr ($formdata, $ofset);

		# եɲ
		my ($define, $name, $filename);

		# Content-Disposition: եɡɬܡ
		return ("multipart parse error 3") unless (length $head{"content-disposition"} );
		($define, $p_name, $p_filename) = split (/;\s*/, $head{"content-disposition"});
		return ("multipart parse error 4") unless $define eq "form-data";
		my ($key, $name) = &parse_parameter($p_name);
		return ("multipart parse error 5") unless $key eq "name";
		return ("multipart parse error 6") unless length($name);

		my ($key, $filename) = &parse_parameter($p_filename);
		if ($key eq "filename" && length($filename) ){
			$head{"x-filename"} = $filename;
		}

		# Content-type: եɡǤա
		$head{"content-type"} = "text/plain" unless length $head{"content-type"};

		if (length $head{"x-filename"}){
			${$rh_file}{$name} = [ \%head, $body ];
		}else{
			$body =~ s/\r\n?/\n/g;
			$body =~ s/\n$//g;
			&jconv::convert($body, "euc", "", 1);
			${$rh_form}{$name} = $body;
		}
	}

	$error;
}

sub parse_parameter{
	my ($parameter) = @_;
	
	return unless $parameter =~ s/^([^=]+)=//;
	my $key = $1;
	$parameter = $1 if (
		$parameter =~ /^"([^"]*)"$/ || $parameter =~ /^'([^']*)'$/
	);
	
	return ($key, $parameter);
}



1;
